#!/bin/sh
#========================================================================#
# Purpose: This script runs the static code analyses                     #
# of the 'dsm' project using HPE fortify.                                #
#                                                                        #
# The fortify report is generated in the location, /target               #
# Updates :                                                              #
#       o  (11/6/2018):                                                  #
#          Micro Focus Fortify version updated from 18.10 to 18.20       #
#       o  (7/9/2018):                                                   #
#          Micro Focus Fortify version updated from 17.20 to 18.10       #
#       o  (04/16/2018)                                                  #
#         1) HPE Fortify version used 17.20                              #
#            which is the VA enforced standards                          #
#         1) new RulePacks applied. 18.1.0.0007                          #
#            which is the VA enforced standards                          #
#         2) scan is performed using java version = 1.8                  #
#            as mentioned by the environment varaibale,                  #
#            'fortify.sca.source.version'                                # 
#                                                                        #
#========================================================================#
MVN_ARGS="-Dfortify.sca.buildId=dsm"
FORTIFY_VERSION="18.20"
 
# skip the tests
mvn clean install $MVN_ARGS -Dmaven.test.skip=true

rc=$?

if [ $rc -eq 0 ]; then
  mvn $MVN_ARGS com.fortify.sca.plugins.maven:sca-maven-plugin:$FORTIFY_VERSION:clean

  #mvn $MVN_ARGS -Dfortify.sca.exclude="**/resources/wsdl/**/*.xsd;**/resources/schema/ebRS/*.xsd" -Dfortify.sca.source.version=1.8 com.fortify.sca.plugins.maven:sca-maven-plugin:$FORTIFY_VERSION:translate
  mvn $MVN_ARGS -Dfortify.sca.exclude="**/resources/wsdl/**/*.xsd;**/resources/schema/**/*.xsd" -Dfortify.sca.source.version=1.8 com.fortify.sca.plugins.maven:sca-maven-plugin:$FORTIFY_VERSION:translate

  mvn $MVN_ARGS -Dfortify.sca.Xmx=4096M com.fortify.sca.plugins.maven:sca-maven-plugin:$FORTIFY_VERSION:scan
fi


exit $rc
